<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OwnerDefinedCategory extends Model 
{

    protected $table = 'owner_defined_categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description');

    public function owner()
    {
        return $this->belongsTo('App\Models\Owner');
    }

}